function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Cartel_nonopec_shocks.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(64, 120);
g1(1,22)=T(31)+T(34);
g1(1,25)=T(31);
g1(1,11)=T(33);
g1(1,39)=exp(y(22))*exp(y(25))*T(78);
g1(1,40)=T(117);
g1(1,43)=T(118);
g1(1,46)=T(119);
g1(1,55)=exp(y(22));
g1(1,18)=T(252);
g1(1,20)=T(32)*(-(exp(y(22))*T(24)*exp(params(5)*(-y(46)))));
g1(1,77)=(-1);
g1(1,111)=params(22);
g1(2,23)=T(26)*(-exp(y(23)))+exp(y(23))*y(59)+y(69)*(-(T(30)*params(4)*params(4)*exp(y(23)*params(4))));
g1(2,39)=(-exp(y(23)))*T(78);
g1(2,40)=(-exp(y(23)))*T(91);
g1(2,59)=exp(y(23));
g1(2,69)=(-(T(30)*params(4)*exp(y(23)*params(4))));
g1(2,79)=(-1);
g1(2,113)=params(22);
g1(3,24)=y(68)*(-(T(29)*params(4)*params(4)*exp(y(24)*params(4))))+exp(y(24))*y(59)+y(64)*y(35)*T(29)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,35)=y(64)*T(29)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,59)=exp(y(24));
g1(3,64)=y(35)*T(29)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(3,68)=(-(T(29)*params(4)*exp(y(24)*params(4))));
g1(3,78)=(-1);
g1(3,112)=params(22);
g1(4,22)=T(31);
g1(4,25)=T(26)*T(35)+y(72)*(-exp(y(25)))+exp(y(25))*y(71);
g1(4,39)=T(35)*T(78);
g1(4,40)=T(35)*T(91);
g1(4,45)=T(104);
g1(4,53)=T(26)*T(115);
g1(4,71)=exp(y(25));
g1(4,72)=(-exp(y(25)));
g1(4,81)=(-1);
g1(4,115)=params(22);
g1(5,26)=y(72)*(-exp(y(26)))+exp(y(26))*y(70);
g1(5,70)=exp(y(26));
g1(5,72)=(-exp(y(26)));
g1(5,80)=(-1);
g1(5,114)=params(22);
g1(6,27)=T(37);
g1(6,31)=T(43);
g1(6,95)=T(239);
g1(6,101)=params(22)*exp(y(27))*params(6)*exp(params(5)*(y(31)-y(95)));
g1(6,67)=exp(y(27));
g1(6,104)=params(22)*(-(exp(y(27))*(1-exp((-y(95)))*exp(y(31)))));
g1(6,108)=T(256);
g1(7,28)=T(39);
g1(7,32)=T(124);
g1(7,96)=T(243);
g1(7,101)=params(22)*exp(y(28))*params(6)*exp(params(5)*y(32));
g1(7,66)=exp(y(28));
g1(7,103)=params(22)*(-((1-exp(y(32)-y(96)))*exp(y(28))));
g1(7,107)=T(255);
g1(8,29)=T(40);
g1(8,67)=(-(params(7)*exp(y(29))));
g1(8,69)=exp(y(29));
g1(8,106)=params(22)*(-((1-params(7))*exp(y(29))));
g1(9,30)=T(41);
g1(9,66)=(-(params(7)*exp(y(30))));
g1(9,68)=exp(y(30));
g1(9,105)=params(22)*(-((1-params(7))*exp(y(30))));
g1(10,27)=T(43);
g1(10,31)=params(22)*y(110)*(-exp(y(31)))+T(127);
g1(10,95)=T(240);
g1(10,101)=params(22)*exp(y(27))*params(6)*params(5)*exp(params(5)*(y(31)-y(95)));
g1(10,104)=T(254);
g1(10,108)=T(256);
g1(10,110)=params(22)*(-exp(y(31)));
g1(11,85)=T(121);
g1(11,28)=T(124);
g1(11,32)=T(38)+T(48)+y(65)*T(131)+T(133)+params(22)*y(101)*exp(y(28))*params(6)*params(5)*params(5)*exp(params(5)*y(32));
g1(11,86)=y(62)*(-(T(23)*(-exp(y(32)-y(96)))));
g1(11,93)=y(65)*T(44)+T(47);
g1(11,96)=params(22)*y(107)*(-(exp(y(28))*(-exp(y(32)-y(96)))))+params(22)*y(103)*(-(exp(y(32)-y(96))*exp(y(28))))+T(246);
g1(11,101)=params(22)*exp(y(28))*params(6)*params(5)*exp(params(5)*y(32));
g1(11,62)=T(46);
g1(11,65)=T(44);
g1(11,103)=T(253);
g1(11,107)=T(255);
g1(12,33)=exp(y(33))*y(58);
g1(12,58)=exp(y(33));
g1(13,11)=T(32)*y(18)*(-(T(24)*(-exp(y(11)-y(46)))));
g1(13,43)=T(134);
g1(13,46)=T(135);
g1(13,18)=T(32)*(-(T(24)*(1-exp(y(11)-y(46)))));
g1(13,62)=1;
g1(13,63)=(-params(7));
g1(13,20)=T(32)*T(24)*exp(params(5)*(-y(46)));
g1(14,24)=y(64)*T(29)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(14,43)=T(32)*y(19)*(-(T(24)*(1-params(7))));
g1(14,19)=T(32)*(-(T(24)*(1-params(7))));
g1(14,63)=1;
g1(14,64)=params(4)*exp(y(24)*(params(4)-1))*T(29);
g1(15,36)=T(8)*y(72)+y(55)*(-(params(11)*T(12)*T(138)))+y(54)*(-(T(51)*T(142)+params(11)*T(50)*params(11)*T(50)*T(143)));
g1(15,37)=y(55)*(-(T(49)*params(11)*T(52)));
g1(15,13)=y(54)*(-(params(11)*T(50)*T(143)*T(158)));
g1(15,39)=y(54)*(-(params(11)*T(50)*T(88)*T(143)));
g1(15,44)=y(54)*(-(params(11)*T(50)*T(100)*T(143)));
g1(15,54)=(-(params(11)*T(50)*T(51)));
g1(15,55)=(-(params(11)*T(12)*T(49)));
g1(15,72)=T(8);
g1(16,36)=y(55)*(-(T(49)*params(11)*T(52)));
g1(16,37)=y(59)*(-exp(y(37)))+y(57)*(-(T(5)*T(19)*T(16)*exp(T(1)*y(44))*(1-params(11))*params(3)*T(148)))+y(56)*(-(T(17)*T(3)*T(16)*exp(T(1)*y(44))*(1-params(11))*(1-params(3))*T(148)))+exp(y(37))*y(54)+y(55)*(-(T(14)*params(11)*T(148)));
g1(16,13)=y(57)*T(160)+y(56)*(-(T(17)*T(161)));
g1(16,39)=T(149);
g1(16,44)=T(152);
g1(16,54)=exp(y(37));
g1(16,55)=(-(T(14)*params(11)*T(52)));
g1(16,56)=(-(T(17)*T(3)*T(16)*T(54)));
g1(16,57)=(-(T(5)*T(19)*T(16)*T(53)));
g1(16,59)=(-exp(y(37)));
g1(16,82)=(-1);
g1(16,116)=params(22);
g1(17,88)=params(22)*y(97)*(-(T(61)*params(11)*T(144)*T(145)));
g1(17,89)=params(22)*y(98)*(-(T(65)*(T(57)*T(68)*T(154)+T(58)*T(70)*T(154))))+params(22)*y(99)*T(155);
g1(17,38)=T(20)*y(59)+params(22)*y(101)*(-(T(20)*(1-params(10))))+params(22)*y(97)*(-(T(64)*T(174)+T(61)*T(61)*T(145)))+params(22)*y(98)*(-(T(65)*(T(67)*T(68)*T(172)+T(57)*T(67)*T(70)+T(57)*T(67)*T(70)+T(58)*T(67)*T(176))))+params(22)*y(99)*(-(T(56)*(T(70)*T(72)*T(73)+T(71)*T(72)*T(176)+T(70)*T(72)*T(73)+T(68)*T(72)*T(179))))+params(22)*y(100)*(-(exp((1-params(3))*y(90))*exp(T(1)*y(94))*params(3)*params(3)*exp(params(3)*y(38))));
g1(17,90)=params(22)*y(97)*(-(T(64)*T(212)+T(61)*T(145)*T(55)*T(60)*T(58)*T(211)))+params(22)*y(98)*(-((T(57)*T(67)*T(68)+T(58)*T(67)*T(70))*T(213)+T(65)*(T(57)*T(67)*T(69)*T(58)*T(211)+T(58)*T(67)*T(214))))+params(22)*y(99)*(-((T(71)*T(70)*T(72)+T(68)*T(72)*T(73))*T(211)+T(56)*(T(71)*T(72)*T(214)+T(73)*T(72)*T(69)*T(58)*T(211))))+params(22)*y(100)*(-(exp(T(1)*y(94))*params(3)*exp(params(3)*y(38))*(1-params(3))*exp((1-params(3))*y(90))));
g1(17,94)=params(22)*y(97)*(-(T(64)*T(231)+T(61)*T(145)*T(62)*(1-params(11))*T(1)*exp(T(1)*y(94))))+params(22)*y(98)*(-(T(65)*T(233)))+params(22)*y(99)*(-(T(56)*T(234)))+params(22)*y(100)*(-(exp((1-params(3))*y(90))*params(3)*exp(params(3)*y(38))*T(1)*exp(T(1)*y(94))));
g1(17,97)=params(22)*(-(T(61)*T(64)));
g1(17,98)=params(22)*(-(T(65)*(T(57)*T(67)*T(68)+T(58)*T(67)*T(70))));
g1(17,99)=params(22)*T(74);
g1(17,100)=params(22)*(-(exp((1-params(3))*y(90))*exp(T(1)*y(94))*params(3)*exp(params(3)*y(38))));
g1(17,59)=T(20);
g1(17,101)=params(22)*(-(T(20)*(1-params(10))));
g1(18,22)=exp(y(22))*exp(y(25))*T(78);
g1(18,23)=(-exp(y(23)))*T(78);
g1(18,25)=T(35)*T(78);
g1(18,36)=y(54)*(-(T(88)*params(11)*T(50)*T(143)));
g1(18,37)=T(149);
g1(18,13)=y(58)*(-(T(79)*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))))+y(57)*(-(T(81)*(T(19)*T(18)*T(82)*T(157)+T(16)*T(18)*T(159))+T(5)*(T(18)*T(83)*T(159)+T(19)*T(18)*T(163))))+y(56)*(-(T(17)*(T(15)*T(83)*T(156)+T(3)*T(15)*T(163))+T(85)*T(164)))+y(54)*(-(T(88)*T(143)*T(158)+T(51)*T(166)));
g1(18,14)=y(61)*T(184);
g1(18,39)=(T(35)-exp(y(23)))*T(191)+y(61)*(-(params(1)*T(191)/T(28)))+T(4)*y(60)+y(58)*(-(exp(T(1)*y(44))*exp(y(13)*params(3))*(1-params(3))*T(79)))+y(57)*T(196)+y(56)*T(200)+y(54)*(-(T(88)*T(88)*T(143)+T(51)*T(201)))+params(22)*y(102)*T(203);
g1(18,90)=params(22)*y(102)*(-((-(T(78)*T(218)))/(T(26)*T(26))));
g1(18,15)=y(61)*T(219);
g1(18,40)=(T(35)-exp(y(23)))*T(221)+y(61)*(-(params(1)*T(221)/T(28)))+params(22)*y(102)*T(223);
g1(18,91)=params(22)*y(102)*(-((-(T(78)*params(1)*exp(y(91))*T(217)))/(T(26)*T(26))));
g1(18,44)=y(58)*(-(T(79)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+T(207)+T(208)+y(54)*(-(T(51)*T(209)+T(88)*T(100)*T(143)));
g1(18,45)=T(210);
g1(18,53)=T(78)*T(115);
g1(18,54)=(-(T(51)*T(88)));
g1(18,56)=T(86);
g1(18,57)=T(84);
g1(18,58)=T(80);
g1(18,60)=T(4);
g1(18,61)=(-(params(1)*T(78)/T(28)));
g1(18,102)=params(22)*(-((-(T(78)*T(90)))/(T(26)*T(26))));
g1(19,22)=T(117);
g1(19,23)=(-exp(y(23)))*T(91);
g1(19,25)=T(35)*T(91);
g1(19,14)=y(61)*T(185);
g1(19,39)=(T(35)-exp(y(23)))*T(204)+y(61)*(-(params(1)*T(204)/T(28)))+params(22)*y(102)*(-(T(205)/T(202)));
g1(19,90)=params(22)*y(102)*(-((-(T(91)*T(218)))/(T(26)*T(26))));
g1(19,15)=y(61)*T(220);
g1(19,40)=(T(35)-exp(y(23)))*T(224)+y(61)*(-(params(1)*T(224)/T(28)))+exp(y(40))*y(59)+params(22)*y(102)*(-((T(26)*T(26)*(-(T(90)*T(224)))-(-(T(90)*T(91)))*T(222))/T(202)));
g1(19,91)=params(22)*y(102)*(-((-(T(91)*params(1)*exp(y(91))*T(217)))/(T(26)*T(26))));
g1(19,45)=T(91)*T(103);
g1(19,53)=T(91)*T(115);
g1(19,59)=exp(y(40));
g1(19,61)=T(92);
g1(19,102)=params(22)*(-((-(T(90)*T(91)))/(T(26)*T(26))));
g1(20,41)=exp(y(41))*y(57)+T(32)*y(17)*(-(exp(y(41))*T(24)));
g1(20,43)=T(32)*y(17)*(-(exp(y(41))*T(24)));
g1(20,57)=exp(y(41));
g1(20,17)=T(32)*(-(exp(y(41))*T(24)));
g1(21,42)=exp(y(42))*y(56)+y(60)*(-(T(21)*T(227)));
g1(21,56)=exp(y(42));
g1(21,60)=(-(T(21)*T(93)));
g1(22,22)=T(118);
g1(22,11)=T(129);
g1(22,34)=T(134);
g1(22,35)=T(32)*y(19)*(-(T(24)*(1-params(7))));
g1(22,41)=T(32)*y(17)*(-(exp(y(41))*T(24)));
g1(22,43)=T(96);
g1(22,46)=T(114);
g1(22,17)=T(32)*(-(T(24)*(1+exp(y(41))-params(10))));
g1(22,61)=T(24);
g1(22,18)=T(32)*T(95);
g1(22,19)=T(32)*(-(y(35)*T(24)*(1-params(7))));
g1(22,20)=T(32)*T(94);
g1(23,36)=y(54)*(-(T(100)*params(11)*T(50)*T(143)));
g1(23,37)=T(152);
g1(23,13)=y(58)*T(167)+y(57)*(-(T(5)*T(168)))+y(56)*(-(T(17)*T(169)))+y(54)*(-(T(100)*T(143)*T(158)+T(51)*T(99)*T(87)*T(157)));
g1(23,39)=y(58)*(-(T(79)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))))+T(207)+T(208)+y(54)*(-(T(100)*T(88)*T(143)+T(51)*T(209)));
g1(23,44)=y(58)*T(228)+y(57)*(-(T(5)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(44))))+y(56)*T(229)+y(54)*(-(T(100)*T(100)*T(143)+T(51)*T(230)));
g1(23,54)=(-(T(51)*T(100)));
g1(23,56)=(-(T(17)*T(3)*T(16)*T(98)));
g1(23,57)=(-(T(5)*T(19)*T(16)*T(97)));
g1(23,58)=(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))));
g1(23,75)=1;
g1(23,109)=params(22)*(-params(15));
g1(23,117)=T(101)*(-params(16));
g1(24,25)=T(104);
g1(24,6)=T(108);
g1(24,10)=T(125);
g1(24,39)=T(210);
g1(24,40)=T(91)*T(103);
g1(24,45)=T(26)*T(236)+T(237);
g1(24,53)=T(26)*T(250);
g1(24,59)=T(107);
g1(24,67)=T(106);
g1(24,71)=T(105);
g1(24,73)=1;
g1(25,22)=T(119);
g1(25,7)=T(123);
g1(25,11)=y(70)*T(109)+y(66)*T(110)+T(130);
g1(25,34)=T(135);
g1(25,43)=T(114);
g1(25,46)=y(70)*T(110)+y(66)*T(109)+T(242);
g1(25,18)=T(32)*T(112);
g1(25,20)=T(32)*T(113);
g1(25,66)=T(110);
g1(25,70)=T(109);
g1(25,74)=1;
g1(26,77)=1;
g1(27,78)=1;
g1(28,79)=1;
g1(29,80)=1;
g1(30,81)=1;
g1(31,82)=1;
g1(32,25)=T(26)*T(115);
g1(32,39)=T(78)*T(115);
g1(32,40)=T(91)*T(115);
g1(32,45)=T(26)*T(238);
g1(32,53)=exp(y(53))*y(76)+T(26)*T(251);
g1(32,76)=exp(y(53));
g1(33,36)=(-(params(11)*T(50)*T(51)));
g1(33,37)=exp(y(37));
g1(33,13)=(-(T(51)*T(158)));
g1(33,39)=(-(T(51)*T(88)));
g1(33,44)=(-(T(51)*T(100)));
g1(34,22)=exp(y(22));
g1(34,36)=(-(params(11)*T(12)*T(49)));
g1(34,37)=(-(T(14)*params(11)*T(52)));
g1(35,37)=(-(T(17)*T(3)*T(16)*T(54)));
g1(35,13)=(-(T(17)*T(164)));
g1(35,39)=T(86);
g1(35,42)=exp(y(42));
g1(35,44)=(-(T(17)*T(3)*T(16)*T(98)));
g1(36,37)=(-(T(5)*T(19)*T(16)*T(53)));
g1(36,13)=(-(T(5)*(T(19)*T(18)*T(82)*T(157)+T(16)*T(18)*T(159))));
g1(36,39)=T(84);
g1(36,41)=exp(y(41));
g1(36,44)=(-(T(5)*T(19)*T(16)*T(97)));
g1(37,33)=exp(y(33));
g1(37,13)=(-(exp(y(39)*(1-params(3)))*exp(T(1)*y(44))*params(3)*exp(y(13)*params(3))));
g1(37,39)=T(80);
g1(37,44)=(-(exp(y(39)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(44))));
g1(38,23)=exp(y(23));
g1(38,24)=exp(y(24));
g1(38,6)=params(6)*exp(params(5)*(y(10)-y(45)))*exp(y(6));
g1(38,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
g1(38,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(45)));
g1(38,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
g1(38,37)=(-exp(y(37)));
g1(38,13)=(-(exp(y(13))*(1-params(10))));
g1(38,38)=T(20);
g1(38,40)=exp(y(40));
g1(38,45)=T(107);
g1(39,39)=T(4);
g1(39,42)=(-(T(21)*T(93)));
g1(40,92)=(-(T(23)*exp(y(92))));
g1(40,93)=(-(T(23)*(1+exp(y(92))-params(10))));
g1(41,14)=(-((-(params(1)*T(26)*T(183)))/(T(28)*T(28))));
g1(41,39)=(-(params(1)*T(78)/T(28)));
g1(41,15)=(-((-(params(1)*T(26)*exp(y(15))*T(182)))/(T(28)*T(28))));
g1(41,40)=T(92);
g1(41,43)=T(24);
g1(42,85)=T(120);
g1(42,32)=T(46);
g1(42,34)=1;
g1(42,86)=(-(T(23)*(1-exp(y(32)-y(96)))));
g1(42,93)=(-(T(23)*(exp(y(32)-y(96))*exp(y(85))+(1-exp(y(32)-y(96)))*y(86)-params(6)*exp(params(5)*(y(32)-y(96))))));
g1(42,96)=T(247);
g1(43,34)=(-params(7));
g1(43,35)=1;
g1(43,87)=(-(T(23)*(1-params(7))));
g1(43,93)=(-(T(23)*(1-params(7))*y(87)));
g1(44,24)=y(35)*T(29)*params(4)*(params(4)-1)*exp(y(24)*(params(4)-1));
g1(44,35)=params(4)*exp(y(24)*(params(4)-1))*T(29);
g1(45,85)=(-(exp(y(85))*T(23)*exp(params(5)*(-y(96)))));
g1(45,32)=T(44);
g1(45,86)=T(23)*exp(params(5)*(-y(96)));
g1(45,93)=T(116);
g1(45,96)=T(248);
g1(46,7)=(-(exp(y(7))*(1-exp(y(11)-y(46)))));
g1(46,28)=exp(y(28));
g1(46,30)=(-(params(7)*exp(y(30))));
g1(46,11)=T(109);
g1(46,46)=T(110);
g1(47,6)=(-(exp(y(6))*(1-exp((-y(45)))*exp(y(10)))));
g1(47,27)=exp(y(27));
g1(47,29)=(-(params(7)*exp(y(29))));
g1(47,10)=T(126);
g1(47,45)=T(106);
g1(48,24)=(-(T(29)*params(4)*exp(y(24)*params(4))));
g1(48,9)=(-((1-params(7))*exp(y(9))));
g1(48,30)=exp(y(30));
g1(49,23)=(-(T(30)*params(4)*exp(y(23)*params(4))));
g1(49,8)=(-((1-params(7))*exp(y(8))));
g1(49,29)=exp(y(29));
g1(50,26)=exp(y(26));
g1(50,7)=T(110);
g1(50,11)=T(110);
g1(50,46)=T(109);
g1(51,25)=exp(y(25));
g1(51,6)=T(122);
g1(51,10)=T(122);
g1(51,45)=T(105);
g1(52,25)=(-exp(y(25)));
g1(52,26)=(-exp(y(26)));
g1(52,36)=T(8);
g1(53,45)=1;
g1(53,118)=(-1);
g1(54,46)=1;
g1(54,120)=(-1);
g1(55,16)=(-params(15));
g1(55,44)=1;
g1(55,119)=(-1);
g1(55,21)=(-params(16));
g1(56,10)=(-exp(y(10)));
g1(56,53)=exp(y(53));
g1(57,1)=1;
g1(57,22)=(-1);
g1(57,47)=1;
g1(58,3)=1;
g1(58,24)=(-1);
g1(58,48)=1;
g1(59,2)=1;
g1(59,23)=(-1);
g1(59,49)=1;
g1(60,5)=1;
g1(60,26)=(-1);
g1(60,50)=1;
g1(61,4)=1;
g1(61,25)=(-1);
g1(61,51)=1;
g1(62,12)=1;
g1(62,37)=(-1);
g1(62,52)=1;
g1(63,109)=(-1);
g1(63,83)=1;
g1(64,16)=(-1);
g1(64,84)=1;

end
